﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines display mode information.
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/vi_StereoMode.h>

namespace nn { namespace vi {

    /**
     * @brief Provides information about a particular mode available on a display.
     */
    struct DisplayModeInfo
    {
    public:
        typedef uint32_t StereoModeType;

    public:
        int32_t width;     //!< Width in pixels.
        int32_t height;    //!< Height in pixels.
        float refreshRate; //!< Refresh rate in Hz.
        StereoModeType mode;   //!< Stereoscopic 3D mode.
    };

}}
