﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Defines all possible content types for SPD InfoFrames.
 */

#pragma once

namespace nn { namespace vi {

    /**
     * @brief   Content types for use on displays.
     * @details Not all types may be supported on all displays.
     */
    enum ContentType
    {
        ContentType_None,     //!< Use display's current content type.
        ContentType_Graphics, //!< Use the graphics content type.
        ContentType_Cinema,   //!< Use the cinema content type.
        ContentType_Photo,    //!< Use the photo content type.
        ContentType_Game,     //!< Use the game content type.
        ContentType_Max,      //!< The number of valid content types defined.
    };

}}
