﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <system/window.h>

namespace nn{ namespace vi{ namespace native{

    class NativeWindowBuffer
        : public ANativeWindowBuffer
    {
    public:
        NativeWindowBuffer() NN_NOEXCEPT
            : ANativeWindowBuffer()
        {
            this->common.incRef = IncRefImpl;
            this->common.decRef = DecRefImpl;
            this->Clear();
        }

        void Set(int width, int height, int stride, int format, int usage, buffer_handle_t handle) NN_NOEXCEPT
        {
            this->width = width;
            this->height = height;
            this->stride = stride;
            this->format = format;
            this->usage = usage;
            this->handle = handle;
        }

        void Clear() NN_NOEXCEPT
        {
            this->width = 0;
            this->height = 0;
            this->stride = 0;
            this->format = 0;
            this->usage = 0;
            this->handle = 0;
        }

    private:
        static void IncRefImpl(struct android_native_base_t*) NN_NOEXCEPT
        {
            // we don't use refcount
        }

        static void DecRefImpl(struct android_native_base_t*) NN_NOEXCEPT
        {
            // we don't use refcount
        }

    };

}}}
