﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/manager/vi_Manager.h>
#include <nn/vi/fbshare/vi_SharedLayerHandle.h>

namespace nn{ namespace vi{ namespace manager{
    class ManagerSharedLowLevelLayer;

    class ManagerSharedLayer
    {
    public:
        ManagerSharedLayer() NN_NOEXCEPT;

        // @pre true
        bool IsInitialized() const NN_NOEXCEPT;

        // @pre IsInitialzied
        bool IsAttached() const NN_NOEXCEPT;

        // @pre IsInitialzied
        nn::vi::fbshare::SharedLayerHandle GetHandle() const NN_NOEXCEPT;

        // @pre !IsInitialized
        // @post IsInitialized
        void Initialize(
            nn::vi::manager::DisplayManagerService* pService,
            nn::applet::AppletResourceUserId userAruid
        ) NN_NOEXCEPT;

        // @pre IsInitialzied
        // @post IsInitialized
        void Finalize() NN_NOEXCEPT;

    private:
        friend class ManagerSharedLowLevelLayer;

        nn::vi::manager::DisplayManagerService* m_pService;
        nn::vi::fbshare::SharedLayerHandle m_Handle;

        // Attach/Detach 時に ManagerSharedLowLevelLayer によって書き換えられる
        ManagerSharedLowLevelLayer*        m_pAttachedLowLevelLayer;

    };

}}}
