﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/manager/vi_Manager.h>
#include <nn/vi/fbshare/vi_SharedBufferHandle.h>
#include <nn/vi/fbshare/vi_SharedMemoryPoolLayout.h>

namespace nn{ namespace vi{ namespace manager{

    class ManagerSharedBuffer
    {
    public:
        ManagerSharedBuffer() NN_NOEXCEPT;

        // @pre true
        bool IsInitialized() const NN_NOEXCEPT;

        // @pre IsInitialized
        nn::vi::fbshare::SharedBufferHandle GetHandle() const NN_NOEXCEPT;

        // @pre !IsInitialized
        // @post IsInitialized
        void Initialize(
            DisplayManagerService* pService,
            const nn::vi::fbshare::SharedMemoryPoolLayout& layout
        ) NN_NOEXCEPT;

        // @pre IsInitialized
        // @post !IsInitialized
        void Finalize() NN_NOEXCEPT;

        // @pre IsInitialized
        void RegisterImporter(nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;

        // @pre IsInitialized
        void UnregisterImporter(nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;

    private:
        DisplayManagerService* m_pService;
        nn::vi::fbshare::SharedBufferHandle m_Handle;
    };

}}}

