﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Type to allow nn::hid to inject hooks into the message procedures.
 * @details This file is not to be distributed in any package and is meant for internal
 *          SDK developers only.
 */

#pragma once

#include <nn/nn_Windows.h>

namespace nn { namespace vi {

    /**
     * @brief Provides information about the windows applications have created through
     *        nn::vi.
     */
    struct WindowInfo
    {
        HWND windowHandle;  //!< Window handle.
        bool isTouchscreen; //!< Denotes whether this window represents a touchscreen
                            //!< on the actual device.
    };

}}
