﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/vi/fbshare/vi_SharedBufferConfig.h>

namespace nn{ namespace vi{ namespace fbshare{

    struct SharedMemoryPoolLayoutEntry
    {
        int64_t offset;
        int64_t size;
        int32_t width;
        int32_t height;
    };

    //! @brief SharedMemoryPool 中のテクスチャのレイアウトを表します。
    struct SharedMemoryPoolLayout
    {
        int32_t count;
        char _reserved0[4];
        SharedMemoryPoolLayoutEntry entries[SharedBufferTextureCountMax];
    };

}}}
