﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn{ namespace vi{ namespace fbshare{

    //! @brief 共有バッファのハンドル
    struct SharedBufferHandle{
    public:
        static SharedBufferHandle GetInvalidValue() NN_NOEXCEPT
        {
            return { 0 };
        }

        bool IsInvalid() const NN_NOEXCEPT
        {
            return this->_value == 0;
        }

        bool operator==(const SharedBufferHandle& v) const NN_NOEXCEPT
        {
            return this->_value == v._value;
        }

        bool operator!=(const SharedBufferHandle& v) const NN_NOEXCEPT
        {
            return this->_value != v._value;
        }

    public:
        uint64_t _value;
    };

}}}
