﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>

#define NN_VI_DEFAULT_INDIRECT_DISPLAY_TRANSACTION_PROXY_NAME "indrct"

namespace nn{ namespace vi{ namespace detail{

    class IndirectLayerTable;

    class SystemServiceProxy
    {
    public:
        static const size_t ObjectCountMax = 10;
    public:
        SystemServiceProxy() NN_NOEXCEPT;
        ~SystemServiceProxy() NN_NOEXCEPT;

        // for default layer
        nn::Result Initialize() NN_NOEXCEPT;

        // for indirect layer
        nn::Result InitializeIndirectDisplay() NN_NOEXCEPT;

        // for shared layer
        nn::Result InitializeForSharedBuffer() NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService> GetApplicationDisplayService() NN_NOEXCEPT;
        nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService> GetApplicationDisplayBlockingService() NN_NOEXCEPT;
        nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService> GetSystemDisplayService() NN_NOEXCEPT;

        IndirectLayerTable* GetIndirectLayerTable() NN_NOEXCEPT;

    private:
        nn::Result InitializeSystemServiceRootImpl(const char* serviceName) NN_NOEXCEPT;
        void FinalizeSystemServiceRootImpl() NN_NOEXCEPT;

        nn::Result InitializeApplicationDisplayServiceImpl(const nn::vi::ProxyNameSafe& proxyName) NN_NOEXCEPT;
        void FinalizeApplicationDisplayServiceImpl() NN_NOEXCEPT;

        nn::Result InitializeSystemDisplayServiceImpl() NN_NOEXCEPT;
        void FinalizeSystemDisplayServiceImpl() NN_NOEXCEPT;

        nn::Result InitializeRelayServiceImpl() NN_NOEXCEPT;
        void FinalizeRelayServiceImpl() NN_NOEXCEPT;

        nn::Result InitializeIndirectDisplayTransactionServiceImpl() NN_NOEXCEPT;
        void FinalizeIndirectDisplayTransactionServiceImpl() NN_NOEXCEPT;

    private:
        nn::sf::SimpleAllInOneHipcClientManager<ObjectCountMax>            m_ClientManager;
        nn::sf::ShimLibraryObjectHolder<nn::visrv::sf::ISystemRootService> m_RootServiceHolder;
        nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>   m_pApplicationDisplayService;
        nn::sf::SharedPointer<nn::visrv::sf::ISystemDisplayService>        m_pSystemDisplayService;
        nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>            m_pRelayService;
        nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver>            m_pIndirectDisplayTransactionService;

        nn::vi::ProxyNameSafe m_RelayProxyName;
        nn::vi::ProxyNameSafe m_IndirectDisplayTransactionProxyName;
        IndirectLayerTable* m_pIndirectLayerTable;
        NN_ALIGNAS(8) char m_IndirectLayerTableStorage[256];
    };

}}}
