﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      vi モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_VI_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(vi, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_VI_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_VI_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_VI_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_VI_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(vi, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_VI_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(vi, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_VI_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(vi, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_VI_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(vi, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_VI_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(vi, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_VI_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(vi, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_VI_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(vi, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_VI_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(vi, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_VI_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(vi, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_VI_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_VI_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_VI_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_VI_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(vi, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_VI_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_VI_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_VI_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(vi, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_VI_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Trace, 0, format, args)
#define NN_DETAIL_VI_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Trace, 1, format, args)
#define NN_DETAIL_VI_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Trace, 2, format, args)
#define NN_DETAIL_VI_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Trace, 3, format, args)

#define NN_DETAIL_VI_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Info, 0, format, args)
#define NN_DETAIL_VI_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Info, 1, format, args)
#define NN_DETAIL_VI_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Info, 2, format, args)
#define NN_DETAIL_VI_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Info, 3, format, args)

#define NN_DETAIL_VI_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Warn, 0, format, args)
#define NN_DETAIL_VI_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Warn, 1, format, args)
#define NN_DETAIL_VI_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Warn, 2, format, args)
#define NN_DETAIL_VI_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Warn, 3, format, args)

#define NN_DETAIL_VI_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Error, 0, format, args)
#define NN_DETAIL_VI_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Error, 1, format, args)
#define NN_DETAIL_VI_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Error, 2, format, args)
#define NN_DETAIL_VI_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Error, 3, format, args)

#define NN_DETAIL_VI_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Fatal, 0, format, args)
#define NN_DETAIL_VI_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Fatal, 1, format, args)
#define NN_DETAIL_VI_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Fatal, 2, format, args)
#define NN_DETAIL_VI_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(vi, Fatal, 3, format, args)

#define NN_DETAIL_VI_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(vi, Trace, 0, text, length)
#define NN_DETAIL_VI_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Trace, 1, text, length)
#define NN_DETAIL_VI_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Trace, 2, text, length)
#define NN_DETAIL_VI_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Trace, 3, text, length)

#define NN_DETAIL_VI_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(vi, Info, 0, text, length)
#define NN_DETAIL_VI_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(vi, Info, 1, text, length)
#define NN_DETAIL_VI_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(vi, Info, 2, text, length)
#define NN_DETAIL_VI_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(vi, Info, 3, text, length)

#define NN_DETAIL_VI_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(vi, Warn, 0, text, length)
#define NN_DETAIL_VI_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(vi, Warn, 1, text, length)
#define NN_DETAIL_VI_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(vi, Warn, 2, text, length)
#define NN_DETAIL_VI_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(vi, Warn, 3, text, length)

#define NN_DETAIL_VI_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(vi, Error, 0, text, length)
#define NN_DETAIL_VI_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Error, 1, text, length)
#define NN_DETAIL_VI_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Error, 2, text, length)
#define NN_DETAIL_VI_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Error, 3, text, length)

#define NN_DETAIL_VI_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(vi, Fatal, 0, text, length)
#define NN_DETAIL_VI_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Fatal, 1, text, length)
#define NN_DETAIL_VI_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Fatal, 2, text, length)
#define NN_DETAIL_VI_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(vi, Fatal, 3, text, length)
