﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   USB::PD ドライバライブラリの API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/usb/pd/driver/usb_PdLib.h>
#include <nn/usb/pd/usb_PdCradleVdm.h>

namespace nn {
namespace usb {
namespace pd {
namespace driver {

/**
 * @brief セッション用パラメータ
 */
struct CradleSession : public SessionCore
{
};

void OpenCradleSession( CradleSession* pOutSession ) NN_NOEXCEPT;
void CloseCradleSession( CradleSession* pSession ) NN_NOEXCEPT;

Result SetCradleVdo( const CradleSession& session, uint32_t outValue, uint32_t command ) NN_NOEXCEPT;
Result GetCradleVdo( uint32_t* pOutValue, const CradleSession& session, uint32_t command ) NN_NOEXCEPT;
Result ResetCradleUsbHub( const CradleSession& session ) NN_NOEXCEPT;
Result GetHostPdcFirmwareType( uint16_t* pOutValue, const CradleSession& session ) NN_NOEXCEPT;
Result GetHostPdcFirmwareRevision( uint16_t* pOutValue, const CradleSession& session ) NN_NOEXCEPT;
Result GetHostPdcManufactureId( uint16_t* pOutValue, const CradleSession& session ) NN_NOEXCEPT;
Result GetHostPdcDeviceId( uint16_t* pOutValue, const CradleSession& session ) NN_NOEXCEPT;
Result EnableCradleRecovery( bool* pIsSuspended, const CradleSession& session ) NN_NOEXCEPT;
Result DisableCradleRecovery( bool* pIsSuspended, const CradleSession& session ) NN_NOEXCEPT;

} // driver
} // pd
} // usb
} // nn

