﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/timesrv/detail/service/timesrv_ISystemClock.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_ISteadyClock.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_ITimeZoneService.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h>
#include <nn/timesrv/detail/service/timesrv_Capabilities.h>

#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_ExpHeapAllocator.h>


namespace nn
{
namespace timesrv
{
namespace detail
{

namespace core
{
    class StandardLocalSystemClockCore;
    class StandardUserSystemClockCore;
    class StandardNetworkSystemClockCore;
    class StandardSteadyClockCore;
    class TimeZoneServiceCore;
    class EphemeralNetworkSystemClockCore;
    class SharedMemoryManager;
}

namespace service
{

class ServiceProvider;

class StaticServiceServer
{
private:
    const Capabilities m_Capabilities;
    nn::sf::ExpHeapAllocator* m_pExpHeapAllocator;

    nn::timesrv::detail::core::StandardLocalSystemClockCore* m_pStandardLocalSystemClockCore;
    nn::timesrv::detail::core::StandardUserSystemClockCore* m_pStandardUserSystemClockCore;
    nn::timesrv::detail::core::StandardNetworkSystemClockCore* m_pStandardNetworkSystemClockCore;
    nn::timesrv::detail::core::StandardSteadyClockCore* m_pStandardSteadyClockCore;
    nn::timesrv::detail::core::TimeZoneServiceCore* m_pTimeZoneServiceCore;
    nn::timesrv::detail::core::EphemeralNetworkSystemClockCore* m_pEphemeralNetworkSystemClockCore;
    nn::timesrv::detail::core::SharedMemoryManager* m_pSharedMemoryManager;

public:
    StaticServiceServer(
        const Capabilities& capabilities,
        ServiceProvider* pServiceProvider,
        nn::sf::ExpHeapAllocator* pExpHeapAllocator
    ) NN_NOEXCEPT;

    ~StaticServiceServer() NN_NOEXCEPT;

    Result GetStandardUserSystemClock(
        nn::sf::Out<nn::sf::SharedPointer<ISystemClock>> outStandardUserSystemClock) NN_NOEXCEPT;

    Result GetStandardNetworkSystemClock(
        nn::sf::Out<nn::sf::SharedPointer<ISystemClock>> outStandardNetworkSystemClock) NN_NOEXCEPT;

    Result GetEphemeralNetworkSystemClock(
        nn::sf::Out<nn::sf::SharedPointer<ISystemClock>> outEphemeralNetworkSystemClock) NN_NOEXCEPT;

    Result GetStandardLocalSystemClock(
        nn::sf::Out<nn::sf::SharedPointer<ISystemClock>> outStandardLocalSystemClock) NN_NOEXCEPT;

    Result GetStandardSteadyClock(
        nn::sf::Out<nn::sf::SharedPointer<ISteadyClock>> outStandardSteadyClock) NN_NOEXCEPT;

    Result GetTimeZoneService(
        nn::sf::Out<nn::sf::SharedPointer<ITimeZoneService>> outTimeZoneService) NN_NOEXCEPT;

    Result GetSharedMemoryNativeHandle(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;

    Result SetStandardSteadyClockInternalOffset(nn::TimeSpanType internalOffset) NN_NOEXCEPT;

    Result IsStandardUserSystemClockAutomaticCorrectionEnabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    Result SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT;

    Result IsStandardNetworkSystemClockAccuracySufficient(nn::sf::Out<bool> outValue) NN_NOEXCEPT;

    Result GetStandardUserSystemClockAutomaticCorrectionUpdatedTime(
        nn::sf::Out<nn::time::SteadyClockTimePoint> outValue) NN_NOEXCEPT;

    Result CalculateMonotonicSystemClockBaseTimePoint(
        nn::sf::Out<int64_t> outValue,
        const nn::time::SystemClockContext& systemClockContext) NN_NOEXCEPT;

    Result GetClockSnapshot(nn::sf::Out<nn::time::sf::ClockSnapshot> outValue, uint8_t initialType) NN_NOEXCEPT;

    // version0
    Result GetClockSnapshotFromSystemClockContext(
        nn::sf::Out<nn::time::sf::ClockSnapshot> outValue,
        const nn::time::SystemClockContext& userSystemClockContext,
        const nn::time::SystemClockContext& netSystemClockContext,
        uint8_t initialType) NN_NOEXCEPT;

    Result CalculateStandardUserSystemClockDifferenceByUser(
        nn::sf::Out<nn::TimeSpanType> outValue,
        const nn::time::sf::ClockSnapshot& from,
        const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT;

    Result CalculateSpanBetween(
        nn::sf::Out<nn::TimeSpanType> outValue,
        const nn::time::sf::ClockSnapshot& from,
        const nn::time::sf::ClockSnapshot& to) NN_NOEXCEPT;

    Result GetStandardUserSystemClockInitialYear(nn::sf::Out<int32_t> outValue) NN_NOEXCEPT;
};

}
}
}
}
