﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/time/time_CalendarTime.h>
#include <nn/time/time_LocationName.h>
#include <nn/time/time_TimeZone.h>
#include <nn/time/time_TimeZoneRule.h>
#include <nn/time/time_TimeZoneRuleVersion.h>
#include <nn/time/time_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace time { namespace sf { // NOLINT(whitespace/braces)

struct CalendarAdditionalInfo;

}}}

namespace nn { namespace timesrv { namespace detail { namespace service { // NOLINT(whitespace/braces)

class ITimeZoneService;

}}}}

namespace nn { namespace time { namespace sf { // NOLINT(whitespace/braces)

struct CalendarAdditionalInfo
{
    std::int8_t dayOfWeek;
    std::int32_t yearDay;
    nn::time::TimeZone timeZone;
};

}}}

namespace nn { namespace timesrv { namespace detail { namespace service { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ITimeZoneService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ITimeZoneService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceLocationName, (::nn::sf::Out<::nn::time::LocationName> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceLocationName, (const ::nn::time::LocationName& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalLocationNameCount, (::nn::sf::Out<::std::int32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadLocationNameList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::LocationName>& pOutLocationNameList, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadTimeZoneRule, (::nn::sf::Out<::nn::time::TimeZoneRule> outValue, const ::nn::time::LocationName& locationName))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTimeZoneRuleVersion, (::nn::sf::Out<::nn::time::TimeZoneRuleVersion> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceLocationNameAndUpdatedTime, (::nn::sf::Out<::nn::time::LocationName> outLocationName, ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outUpdatedTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ToCalendarTime, (::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime, const ::nn::time::TimeZoneRule& rule))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ToCalendarTimeWithMyRule, (::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ToPosixTime, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime, const ::nn::time::TimeZoneRule& rule))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ToPosixTimeWithMyRule, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ITimeZoneService)

        ::nn::Result GetDeviceLocationName(::nn::sf::Out<::nn::time::LocationName> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceLocationName, (outValue));
        }

        ::nn::Result SetDeviceLocationName(const ::nn::time::LocationName& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDeviceLocationName, (value));
        }

        ::nn::Result GetTotalLocationNameCount(::nn::sf::Out<::std::int32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTotalLocationNameCount, (outValue));
        }

        ::nn::Result LoadLocationNameList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::LocationName>& pOutLocationNameList, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadLocationNameList, (outCount, pOutLocationNameList, offset));
        }

        ::nn::Result LoadTimeZoneRule(::nn::sf::Out<::nn::time::TimeZoneRule> outValue, const ::nn::time::LocationName& locationName) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadTimeZoneRule, (outValue, locationName));
        }

        ::nn::Result GetTimeZoneRuleVersion(::nn::sf::Out<::nn::time::TimeZoneRuleVersion> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTimeZoneRuleVersion, (outValue));
        }

        ::nn::Result GetDeviceLocationNameAndUpdatedTime(::nn::sf::Out<::nn::time::LocationName> outLocationName, ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outUpdatedTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeviceLocationNameAndUpdatedTime, (outLocationName, outUpdatedTime));
        }

        ::nn::Result ToCalendarTime(::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime, const ::nn::time::TimeZoneRule& rule) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ToCalendarTime, (outCalendarTime, outCalendarAdditionalInfo, posixTime, rule));
        }

        ::nn::Result ToCalendarTimeWithMyRule(::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ToCalendarTimeWithMyRule, (outCalendarTime, outCalendarAdditionalInfo, posixTime));
        }

        ::nn::Result ToPosixTime(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime, const ::nn::time::TimeZoneRule& rule) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ToPosixTime, (outCount, outPosixTimeList, calendarTime, rule));
        }

        ::nn::Result ToPosixTimeWithMyRule(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ToPosixTimeWithMyRule, (outCount, outPosixTimeList, calendarTime));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ITimeZoneService
    {
    public:
        nn::Result GetDeviceLocationName(nn::sf::Out<nn::time::LocationName> outValue) NN_NOEXCEPT;
        nn::Result SetDeviceLocationName(const nn::time::LocationName& value) NN_NOEXCEPT;
        nn::Result GetTotalLocationNameCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
        nn::Result LoadLocationNameList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::LocationName>& pOutLocationNameList, std::int32_t offset) NN_NOEXCEPT;
        nn::Result LoadTimeZoneRule(nn::sf::Out<nn::time::TimeZoneRule> outValue, const nn::time::LocationName& locationName) NN_NOEXCEPT;
        nn::Result GetTimeZoneRuleVersion(nn::sf::Out<nn::time::TimeZoneRuleVersion> outValue) NN_NOEXCEPT;
        nn::Result GetDeviceLocationNameAndUpdatedTime(nn::sf::Out<nn::time::LocationName> outLocationName, nn::sf::Out<nn::time::SteadyClockTimePoint> outUpdatedTime) NN_NOEXCEPT;
        nn::Result ToCalendarTime(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT;
        nn::Result ToCalendarTimeWithMyRule(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime) NN_NOEXCEPT;
        nn::Result ToPosixTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT;
        nn::Result ToPosixTimeWithMyRule(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime) NN_NOEXCEPT;
    };
#endif

}}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetDeviceLocationName(nn::sf::Out<nn::time::LocationName> outValue) NN_NOEXCEPT;
    nn::Result SetDeviceLocationName(const nn::time::LocationName& value) NN_NOEXCEPT;
    nn::Result GetTotalLocationNameCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
    nn::Result LoadLocationNameList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::LocationName>& pOutLocationNameList, std::int32_t offset) NN_NOEXCEPT;
    nn::Result LoadTimeZoneRule(nn::sf::Out<nn::time::TimeZoneRule> outValue, const nn::time::LocationName& locationName) NN_NOEXCEPT;
    nn::Result GetTimeZoneRuleVersion(nn::sf::Out<nn::time::TimeZoneRuleVersion> outValue) NN_NOEXCEPT;
    nn::Result GetDeviceLocationNameAndUpdatedTime(nn::sf::Out<nn::time::LocationName> outLocationName, nn::sf::Out<nn::time::SteadyClockTimePoint> outUpdatedTime) NN_NOEXCEPT;
    nn::Result ToCalendarTime(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT;
    nn::Result ToCalendarTimeWithMyRule(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime) NN_NOEXCEPT;
    nn::Result ToPosixTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT;
    nn::Result ToPosixTimeWithMyRule(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::timesrv::detail::service::ITimeZoneService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceLocationName, (::nn::sf::Out<::nn::time::LocationName> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceLocationName, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceLocationName, (const ::nn::time::LocationName& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDeviceLocationName, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalLocationNameCount, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTotalLocationNameCount, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadLocationNameList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::LocationName>& pOutLocationNameList, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadLocationNameList, (outCount, pOutLocationNameList, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadTimeZoneRule, (::nn::sf::Out<::nn::time::TimeZoneRule> outValue, const ::nn::time::LocationName& locationName))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadTimeZoneRule, (outValue, locationName));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTimeZoneRuleVersion, (::nn::sf::Out<::nn::time::TimeZoneRuleVersion> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTimeZoneRuleVersion, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceLocationNameAndUpdatedTime, (::nn::sf::Out<::nn::time::LocationName> outLocationName, ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outUpdatedTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeviceLocationNameAndUpdatedTime, (outLocationName, outUpdatedTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToCalendarTime, (::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime, const ::nn::time::TimeZoneRule& rule))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ToCalendarTime, (outCalendarTime, outCalendarAdditionalInfo, posixTime, rule));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToCalendarTimeWithMyRule, (::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ToCalendarTimeWithMyRule, (outCalendarTime, outCalendarAdditionalInfo, posixTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToPosixTime, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime, const ::nn::time::TimeZoneRule& rule))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ToPosixTime, (outCount, outPosixTimeList, calendarTime, rule));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToPosixTimeWithMyRule, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ToPosixTimeWithMyRule, (outCount, outPosixTimeList, calendarTime));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::timesrv::detail::service::ITimeZoneService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::timesrv::detail::service::ITimeZoneService))

    // nn::Result GetDeviceLocationName(nn::sf::Out<nn::time::LocationName> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceLocationName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::time::LocationName), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(36)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceLocationName)

    // nn::Result SetDeviceLocationName(const nn::time::LocationName& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDeviceLocationName)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (::nn::time::LocationName), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(36)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDeviceLocationName)

    // nn::Result GetTotalLocationNameCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTotalLocationNameCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTotalLocationNameCount)

    // nn::Result LoadLocationNameList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::LocationName>& pOutLocationNameList, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadLocationNameList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutLocationNameList, 0, (const ::nn::sf::OutArray<::nn::time::LocationName>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutLocationNameList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutLocationNameList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadLocationNameList)

    // nn::Result LoadTimeZoneRule(nn::sf::Out<nn::time::TimeZoneRule> outValue, const nn::time::LocationName& locationName) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadTimeZoneRule)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::time::TimeZoneRule>), 16384, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(locationName, (::nn::time::LocationName), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (locationName))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(36)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(locationName)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadTimeZoneRule)

    // nn::Result GetTimeZoneRuleVersion(nn::sf::Out<nn::time::TimeZoneRuleVersion> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTimeZoneRuleVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::time::TimeZoneRuleVersion), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTimeZoneRuleVersion)

    // nn::Result GetDeviceLocationNameAndUpdatedTime(nn::sf::Out<nn::time::LocationName> outLocationName, nn::sf::Out<nn::time::SteadyClockTimePoint> outUpdatedTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeviceLocationNameAndUpdatedTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outLocationName, (::nn::time::LocationName), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outUpdatedTime, (::nn::time::SteadyClockTimePoint), 40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outLocationName, outUpdatedTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outLocationName), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outUpdatedTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeviceLocationNameAndUpdatedTime)

    // nn::Result ToCalendarTime(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ToCalendarTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(rule, 0, (const ::nn::time::TimeZoneRule&), 16384, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (rule))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(posixTime, (::nn::time::PosixTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (posixTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCalendarTime, (::nn::time::CalendarTime), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCalendarAdditionalInfo, (::nn::time::sf::CalendarAdditionalInfo), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outCalendarTime, outCalendarAdditionalInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCalendarTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCalendarAdditionalInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(posixTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rule)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ToCalendarTime)

    // nn::Result ToCalendarTimeWithMyRule(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ToCalendarTimeWithMyRule)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(posixTime, (::nn::time::PosixTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (posixTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCalendarTime, (::nn::time::CalendarTime), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCalendarAdditionalInfo, (::nn::time::sf::CalendarAdditionalInfo), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outCalendarTime, outCalendarAdditionalInfo))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCalendarTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCalendarAdditionalInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(posixTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ToCalendarTimeWithMyRule)

    // nn::Result ToPosixTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ToPosixTime)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(rule, 0, (const ::nn::time::TimeZoneRule&), 16384, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outPosixTimeList, 1, (const ::nn::sf::OutArray<::nn::time::PosixTime>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (rule, outPosixTimeList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(calendarTime, (::nn::time::CalendarTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (calendarTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPosixTimeList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(calendarTime), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rule)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ToPosixTime)

    // nn::Result ToPosixTimeWithMyRule(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ToPosixTimeWithMyRule)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(202)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outPosixTimeList, 0, (const ::nn::sf::OutArray<::nn::time::PosixTime>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outPosixTimeList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(calendarTime, (::nn::time::CalendarTime), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (calendarTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outPosixTimeList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(calendarTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ToPosixTimeWithMyRule)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::LocationName), 36, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::TimeZoneRule), 16384, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::TimeZoneRuleVersion), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::SteadyClockTimePoint), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::CalendarTime), 8, 2)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::sf::CalendarAdditionalInfo), 24, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::time::PosixTime), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::timesrv::detail::service::ITimeZoneService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::timesrv::detail::service::ITimeZoneService))

    // nn::Result GetDeviceLocationName(nn::sf::Out<nn::time::LocationName> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceLocationName, (::nn::sf::Out<::nn::time::LocationName> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceLocationName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceLocationName)
    }

    // nn::Result SetDeviceLocationName(const nn::time::LocationName& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDeviceLocationName, (const ::nn::time::LocationName& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDeviceLocationName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDeviceLocationName)
    }

    // nn::Result GetTotalLocationNameCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalLocationNameCount, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTotalLocationNameCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTotalLocationNameCount)
    }

    // nn::Result LoadLocationNameList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::LocationName>& pOutLocationNameList, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadLocationNameList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::LocationName>& pOutLocationNameList, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadLocationNameList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutLocationNameList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadLocationNameList)
    }

    // nn::Result LoadTimeZoneRule(nn::sf::Out<nn::time::TimeZoneRule> outValue, const nn::time::LocationName& locationName) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadTimeZoneRule, (::nn::sf::Out<::nn::time::TimeZoneRule> outValue, const ::nn::time::LocationName& locationName))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadTimeZoneRule)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(locationName)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadTimeZoneRule)
    }

    // nn::Result GetTimeZoneRuleVersion(nn::sf::Out<nn::time::TimeZoneRuleVersion> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTimeZoneRuleVersion, (::nn::sf::Out<::nn::time::TimeZoneRuleVersion> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTimeZoneRuleVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTimeZoneRuleVersion)
    }

    // nn::Result GetDeviceLocationNameAndUpdatedTime(nn::sf::Out<nn::time::LocationName> outLocationName, nn::sf::Out<nn::time::SteadyClockTimePoint> outUpdatedTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeviceLocationNameAndUpdatedTime, (::nn::sf::Out<::nn::time::LocationName> outLocationName, ::nn::sf::Out<::nn::time::SteadyClockTimePoint> outUpdatedTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeviceLocationNameAndUpdatedTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outLocationName)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outUpdatedTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeviceLocationNameAndUpdatedTime)
    }

    // nn::Result ToCalendarTime(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToCalendarTime, (::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime, const ::nn::time::TimeZoneRule& rule))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ToCalendarTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCalendarTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCalendarAdditionalInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(posixTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rule)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ToCalendarTime)
    }

    // nn::Result ToCalendarTimeWithMyRule(nn::sf::Out<nn::time::CalendarTime> outCalendarTime, nn::sf::Out<nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, nn::time::PosixTime posixTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToCalendarTimeWithMyRule, (::nn::sf::Out<::nn::time::CalendarTime> outCalendarTime, ::nn::sf::Out<::nn::time::sf::CalendarAdditionalInfo> outCalendarAdditionalInfo, ::nn::time::PosixTime posixTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ToCalendarTimeWithMyRule)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCalendarTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCalendarAdditionalInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(posixTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ToCalendarTimeWithMyRule)
    }

    // nn::Result ToPosixTime(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime, const nn::time::TimeZoneRule& rule) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToPosixTime, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime, const ::nn::time::TimeZoneRule& rule))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ToPosixTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPosixTimeList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(calendarTime)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rule)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ToPosixTime)
    }

    // nn::Result ToPosixTimeWithMyRule(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::time::PosixTime>& outPosixTimeList, nn::time::CalendarTime calendarTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ToPosixTimeWithMyRule, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::time::PosixTime>& outPosixTimeList, ::nn::time::CalendarTime calendarTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ToPosixTimeWithMyRule)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outPosixTimeList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(calendarTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ToPosixTimeWithMyRule)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::timesrv::detail::service::ITimeZoneService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::timesrv::detail::service::ITimeZoneService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceLocationName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceLocationName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDeviceLocationName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDeviceLocationName)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTotalLocationNameCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTotalLocationNameCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadLocationNameList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutLocationNameList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadLocationNameList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutLocationNameList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadTimeZoneRule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadTimeZoneRule)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(locationName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTimeZoneRuleVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTimeZoneRuleVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeviceLocationNameAndUpdatedTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeviceLocationNameAndUpdatedTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outLocationName),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outUpdatedTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ToCalendarTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rule)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ToCalendarTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCalendarTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCalendarAdditionalInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(posixTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ToCalendarTimeWithMyRule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ToCalendarTimeWithMyRule)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCalendarTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCalendarAdditionalInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(posixTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ToPosixTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rule)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outPosixTimeList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ToPosixTime)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outPosixTimeList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(calendarTime),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ToPosixTimeWithMyRule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outPosixTimeList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ToPosixTimeWithMyRule)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outPosixTimeList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(calendarTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceLocationName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDeviceLocationName)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTotalLocationNameCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadLocationNameList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadTimeZoneRule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTimeZoneRuleVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeviceLocationNameAndUpdatedTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ToCalendarTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ToCalendarTimeWithMyRule)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ToPosixTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ToPosixTimeWithMyRule)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::timesrv::detail::service::ITimeZoneService))
