﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/timesrv/detail/core/timesrv_SteadyClockCore.h>
#include <nn/util/util_Uuid.h>
#include <nn/os/os_SdkMutex.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

class StandardSteadyClockCore : public SteadyClockCore
{
private:
    virtual Result GetCurrentTimePointImpl(nn::time::SteadyClockTimePoint* pSteadyClockTimePoint) const NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::TimeSpan GetCurrentTimePointValueImpl() const NN_NOEXCEPT NN_OVERRIDE;
    virtual nn::TimeSpan GetTestOffsetImpl() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void SetTestOffsetImpl(const nn::TimeSpan& testOffset) NN_NOEXCEPT NN_OVERRIDE;

    virtual nn::TimeSpan GetInternalOffsetImpl() const NN_NOEXCEPT NN_OVERRIDE;
    virtual void SetInternalOffsetImpl(const nn::TimeSpan& internalOffset) NN_NOEXCEPT NN_OVERRIDE;

    virtual Result GetRtcSecondsImpl(int64_t* pOutValue) NN_NOEXCEPT NN_OVERRIDE;


public:
    StandardSteadyClockCore() NN_NOEXCEPT;
    virtual ~StandardSteadyClockCore() NN_NOEXCEPT;

    /**
     * @brief   時計のソース ID セットアップ
     * @param[out]  pOutLatestClockSourceId セットアップ後の時計のソース ID
     * @param[in]   clockSourceId           前回起動時の時計のソース ID
     * @details
     *  clockSourceId に nn::util::InvalidUuid を指定するとソース ID を作り直します。
     */
    void SetupSourceId(nn::time::SourceId* pOutLatestClockSourceId, const nn::time::SourceId& clockSourceId) NN_NOEXCEPT;

    // 問題調査用途 API
    virtual uint32_t GetSetupResultValue() const NN_NOEXCEPT NN_OVERRIDE;

    /**
     * @brief   時刻のベース値を最新のRTC値で更新
     * @details
     *  時計内部の Tick による経過時間計測の累積誤差を、
     *  最新のRTC値を使って打ち消します。
     *
     *  この関数はスレッドセーフです。
     */
    void UpdateBaseTimeWithRtc() NN_NOEXCEPT;

private:
    mutable nn::os::SdkMutex m_Lock;
    nn::TimeSpan m_TestOffset;
    nn::TimeSpan m_InternalOffset;
    nn::time::SourceId m_SourceId;
    nn::TimeSpan m_BaseTime;
    nn::Result m_SetupResult;
    mutable nn::TimeSpan m_LastReturnedClockValue;

    void InitializeBaseTime(int64_t rtcSeconds) NN_NOEXCEPT;

    Result TryAdjustBaseTimeWithRtc(int tryCount) NN_NOEXCEPT;
    Result TryAdjustBaseTimeWithRtcImpl() NN_NOEXCEPT;
};

}
}
}
}
