﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>

#include <nn/timesrv/detail/core/timesrv_SystemClockCore.h>


namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

class SteadyClockCore;

/**
 * @brief   ネットワークシステム時計のコア実装
 * @details
 *  本クラスはスレッドアンセーフです。
 *
 *  本クラスは永続データの Read/Write は行いません。
 */
class StandardNetworkSystemClockCore : public SystemClockCore
{
    NN_DISALLOW_COPY(StandardNetworkSystemClockCore);
    NN_DISALLOW_MOVE(StandardNetworkSystemClockCore);

private:
    nn::TimeSpan SufficientAccuracyThreshold;

public:
    explicit StandardNetworkSystemClockCore(SteadyClockCore* pSteadyClockCore) NN_NOEXCEPT;
    virtual ~StandardNetworkSystemClockCore() NN_NOEXCEPT;

    void SetSufficientAccuracyThreshold(const nn::TimeSpan& threshold) NN_NOEXCEPT;
    nn::TimeSpan GetSufficientAccuracyThreshold() const NN_NOEXCEPT;
    bool IsStandardNetworkSystemClockAccuracySufficient() const NN_NOEXCEPT;
};

}
}
}
}
