﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/timesrv/detail/core/timesrv_SystemClockCore.h>

#include <nn/os/os_Tick.h>
#include <nn/util/util_Optional.h>

namespace nn
{
namespace timesrv
{
namespace detail
{
namespace core
{

class SteadyClockCore;

/**
 * @brief   短命なネットワーク時計のコア実装
 * @details
 *  シャットダウンをまたぐと未補正になるネットワーク時計です。
 *  Soc外部の単調増加クロックに依存せず、起動毎に補正されることで初めて、時刻を返すことができるようになります。
 *
 *  本クラスはスレッドアンセーフです。
 *  本クラスは永続データの Read/Write は行いません。
 */
class EphemeralNetworkSystemClockCore : public SystemClockCore
{
    NN_DISALLOW_COPY(EphemeralNetworkSystemClockCore);
    NN_DISALLOW_MOVE(EphemeralNetworkSystemClockCore);

public:
    explicit EphemeralNetworkSystemClockCore(SteadyClockCore* pSteadyClockCore) NN_NOEXCEPT
        : SystemClockCore(pSteadyClockCore)
    {
    }
};

}
}
}
}
