﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  タイムゾーンルールのバージョンを扱う構造体の宣言
*/

#pragma once

#include <nn/time/time_Common.h>


namespace nn
{
namespace time
{

/**
 * @brief   タイムゾーンルールのバージョンを表す型です。
 * @details
 *  システムが管理しているタイムゾーンルールのバージョンを表す型です。
 * @see GetTimeZoneRuleVersion()
 */
struct TimeZoneRuleVersion
{
    static const size_t Size = 16; //!< バージョンを表す文字列のサイズ
    char data[Size]; //!< バージョンを表す文字列
};

//! @}
}
}

