﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
*   @file
*   @brief  メニュー向け特権 API の宣言
*/
#pragma once

#include <nn/time/time_Common.h>

#include <nn/time/time_Types.h>

namespace nn
{
namespace time
{

//! @name 特権が必要な StandardUserSystemClock API
//! @{

    /**
     * @brief       StandardUserSystemClock の自動補正の有効性を設定します。
     * @param[in]   value   設定する状態。 true だと自動補正有効、 false だと自動補正無効を指します。
     *
     * @pre
     *  - TIME ライブラリが nn::time::InitializeForMenu 関数で初期化されている
     *
     * @details
     *  以下の条件を満たすとき、 nn::time::StandardUserSystemClock は nn::time::StandardNetworkSystemClock と同等の時刻を返します。
     *  - nn::time::StandardUserSystemClock のネットワーク自動補正が有効
     *  - かつ、ネットワーク時計( nn::time::StandardNetworkSystemClock )が補正済
     *
     *  この関数を成功させるには、特権が必要です。
     */
    void SetStandardUserSystemClockAutomaticCorrectionEnabled(bool value) NN_NOEXCEPT;

    /**
     * @brief   StandardUserSystemClock の自動補正の有効性を取得します。
     *
     * @return  自動補正の有効性。
     * @retval  true    自動補正は有効
     * @retval  false   自動補正は無効
     *
     * @pre
     *  - TIME ライブラリが初期化されている
     *
     * @details
     *  以下の条件を満たすとき、 nn::time::StandardUserSystemClock は nn::time::StandardNetworkSystemClock と同等の時刻を返します。
     *  - nn::time::StandardUserSystemClock のネットワーク自動補正が有効
     *  - かつ、ネットワーク時計( nn::time::StandardNetworkSystemClock )が補正済
     *
     *  一度も設定されたことがない初期状態では、自動補正は有効です。
     */
     bool IsStandardUserSystemClockAutomaticCorrectionEnabled() NN_NOEXCEPT;

//! @}

}
}
