﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/detail/time_CommonDetail.h>
#include <nn/time/time_CalendarTime.h>

namespace nn { namespace time { namespace detail { namespace util {

// libnn_time , libnn_timesrv の両方で使う可能性のある、
// IPCを介さないCPUだけで処理される API 群を定義.

Result GetSpanBetween(int64_t* pOutSeconds, const SteadyClockTimePoint& from, const SteadyClockTimePoint& to) NN_NOEXCEPT;
bool IsLeapYear(int year) NN_NOEXCEPT;
bool IsValidDate(int year, int month, int day) NN_NOEXCEPT;
int GetDaysInMonth(int year, int month) NN_NOEXCEPT;
int DateToDays(int year, int month, int day) NN_NOEXCEPT;
void DaysToDate(int *pOutYear, int *pOutMonth, int *pOutDay, int days) NN_NOEXCEPT;
DayOfWeek GetDayOfWeek(int year, int month, int day) NN_NOEXCEPT;
PosixTime ToPosixTimeFromUtc(const CalendarTime& calendarTime) NN_NOEXCEPT;
CalendarTime ToCalendarTimeInUtc(const PosixTime& posixTime) NN_NOEXCEPT;

}}}}
