﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/os/os_SharedMemory.h>
#include <nn/time/time_SteadyClockTimePoint.h>
#include <nn/time/time_SystemClockContext.h>
#include <nn/util/util_LockFreeAtomicType.h>

namespace nn { namespace time { namespace detail {

static const size_t SharedMemoryMappingSize = nn::os::MemoryPageSize; //!< マッピングする共有メモリサイズ

//!< 共有メモリアクセス用の構造体
struct SharedMemoryClockSettings
{
    struct StandardSteadyClockTimePointType
    {
        nn::TimeSpanType baseTime;
        nn::time::SourceId sourceId;
    };
    nn::util::LockFreeAtomicType<StandardSteadyClockTimePointType> standardSteadyClockTimePoint;

    nn::util::LockFreeAtomicType<nn::time::SystemClockContext> standardLocalSystemClockContext;
    nn::util::LockFreeAtomicType<nn::time::SystemClockContext> standardNetworkSystemClockContext;
    nn::util::LockFreeAtomicType<bool> isStandardUserSystemClockAutomaticCorrectionEnabled;
};

}}}
