﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      time モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_TIME_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(time, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_TIME_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_TIME_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_TIME_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_TIME_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(time, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_TIME_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(time, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_TIME_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(time, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_TIME_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(time, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_TIME_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(time, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_TIME_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(time, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_TIME_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(time, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_TIME_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(time, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_TIME_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(time, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_TIME_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_TIME_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_TIME_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_TIME_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(time, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_TIME_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_TIME_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_TIME_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(time, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_TIME_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(time, Trace, 0, format, args)
#define NN_DETAIL_TIME_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Trace, 1, format, args)
#define NN_DETAIL_TIME_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Trace, 2, format, args)
#define NN_DETAIL_TIME_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Trace, 3, format, args)

#define NN_DETAIL_TIME_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(time, Info, 0, format, args)
#define NN_DETAIL_TIME_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(time, Info, 1, format, args)
#define NN_DETAIL_TIME_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(time, Info, 2, format, args)
#define NN_DETAIL_TIME_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(time, Info, 3, format, args)

#define NN_DETAIL_TIME_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(time, Warn, 0, format, args)
#define NN_DETAIL_TIME_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(time, Warn, 1, format, args)
#define NN_DETAIL_TIME_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(time, Warn, 2, format, args)
#define NN_DETAIL_TIME_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(time, Warn, 3, format, args)

#define NN_DETAIL_TIME_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(time, Error, 0, format, args)
#define NN_DETAIL_TIME_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Error, 1, format, args)
#define NN_DETAIL_TIME_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Error, 2, format, args)
#define NN_DETAIL_TIME_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Error, 3, format, args)

#define NN_DETAIL_TIME_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(time, Fatal, 0, format, args)
#define NN_DETAIL_TIME_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Fatal, 1, format, args)
#define NN_DETAIL_TIME_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Fatal, 2, format, args)
#define NN_DETAIL_TIME_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(time, Fatal, 3, format, args)

#define NN_DETAIL_TIME_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(time, Trace, 0, text, length)
#define NN_DETAIL_TIME_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Trace, 1, text, length)
#define NN_DETAIL_TIME_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Trace, 2, text, length)
#define NN_DETAIL_TIME_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Trace, 3, text, length)

#define NN_DETAIL_TIME_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(time, Info, 0, text, length)
#define NN_DETAIL_TIME_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(time, Info, 1, text, length)
#define NN_DETAIL_TIME_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(time, Info, 2, text, length)
#define NN_DETAIL_TIME_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(time, Info, 3, text, length)

#define NN_DETAIL_TIME_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(time, Warn, 0, text, length)
#define NN_DETAIL_TIME_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(time, Warn, 1, text, length)
#define NN_DETAIL_TIME_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(time, Warn, 2, text, length)
#define NN_DETAIL_TIME_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(time, Warn, 3, text, length)

#define NN_DETAIL_TIME_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(time, Error, 0, text, length)
#define NN_DETAIL_TIME_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Error, 1, text, length)
#define NN_DETAIL_TIME_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Error, 2, text, length)
#define NN_DETAIL_TIME_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Error, 3, text, length)

#define NN_DETAIL_TIME_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(time, Fatal, 0, text, length)
#define NN_DETAIL_TIME_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Fatal, 1, text, length)
#define NN_DETAIL_TIME_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Fatal, 2, text, length)
#define NN_DETAIL_TIME_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(time, Fatal, 3, text, length)
