﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time/time_Common.h>
#include <nn/time/time_Types.h>
#include <nn/time/time_ResultPrivate.h>
#include <nn/time/detail/config/time_ConfigDetail.h>
#include <nn/time/detail/time_Log.h>

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_StaticAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_LockGuard.h>
#include <nn/util/util_ScopeExit.h>

#define NN_DETAIL_TIME_ASSERT_IF_RESULT_FAILURE(exp) \
    do \
    { \
        auto _result = (exp); \
        NN_SDK_ASSERT(_result.IsSuccess(), #exp " failed. (%08x, %03d-%04d)", \
            _result.GetInnerValueForDebug(), \
            _result.GetModule(), _result.GetDescription()); \
        NN_UNUSED(_result); \
    } \
    while (NN_STATIC_CONDITION(false))
