﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/time/time_Types.h>
#include <nn/time/time_ClockSnapshot.h>
#include <nn/time/detail/time_ClockSnapshotInitialType.h>
#include <nn/timesrv/detail/service/timesrv_IStaticService.sfdl.h> // for nn::time::sf::ClockSnapshot

namespace nn { namespace time { namespace detail {

nn::time::sf::ClockSnapshot* GetSfClockSnapshotPtr(ClockSnapshot* p) NN_NOEXCEPT;
const nn::time::sf::ClockSnapshot* GetSfClockSnapshotPtr(const ClockSnapshot* p) NN_NOEXCEPT;
ClockSnapshotInitialType GetClockSnapshotInitialType(const ClockSnapshot& snapshot) NN_NOEXCEPT;
bool IsClockSnapshotAutomaticCorrectionEnabled(const ClockSnapshot& snapshot) NN_NOEXCEPT;

}}}
