﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief TCAP ライブラリの API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

#include <nn/os/os_SystemEvent.h>

namespace nn { namespace tcap {

//! @name TCAP ライブラリの API
//! @{

/**
 * @brief       表面温度が長時間高温であるときにシグナルされるシステムイベントを取得します。
 *
 * @details     表面温度が長時間高温であるときにシグナルされるシステムイベントを取得します。@n
 *              厳密には製品相当環境で以下の条件を連続 8 時間満たし続けたときにシグナルされます。@n
 *
 *              - 表面温度が推定 48C 以上である
 *              - 動作モードが携帯モードである
 *              - モーションセンサー、タッチパネルなどの一部入力を除いたコントローラ入力の変化がない
 *              - スリープおよびシャットダウン状態ではない
 */
void GetContinuousHighSkinTemperatureEvent(nn::os::SystemEventType* pOutSystemEvent, nn::os::EventClearMode mode) NN_NOEXCEPT;

/**
 * @brief       settings から設定値を再読み込みします。
 *
 * @post        settings の設定が反映されます。@n 反映に再起動は不要です。
 *
 * @details     settings から設定値を再読み込みします。
 */
void LoadAndApplySettings() NN_NOEXCEPT;

//! @}

}} // namepsace nn::tcap
