﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      tcap モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_TCAP_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_TCAP_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_TCAP_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_TCAP_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_TCAP_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_TCAP_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tcap, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_TCAP_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Trace, 0, format, args)
#define NN_DETAIL_TCAP_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Trace, 1, format, args)
#define NN_DETAIL_TCAP_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Trace, 2, format, args)
#define NN_DETAIL_TCAP_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Trace, 3, format, args)

#define NN_DETAIL_TCAP_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Info, 0, format, args)
#define NN_DETAIL_TCAP_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Info, 1, format, args)
#define NN_DETAIL_TCAP_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Info, 2, format, args)
#define NN_DETAIL_TCAP_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Info, 3, format, args)

#define NN_DETAIL_TCAP_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Warn, 0, format, args)
#define NN_DETAIL_TCAP_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Warn, 1, format, args)
#define NN_DETAIL_TCAP_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Warn, 2, format, args)
#define NN_DETAIL_TCAP_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Warn, 3, format, args)

#define NN_DETAIL_TCAP_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Error, 0, format, args)
#define NN_DETAIL_TCAP_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Error, 1, format, args)
#define NN_DETAIL_TCAP_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Error, 2, format, args)
#define NN_DETAIL_TCAP_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Error, 3, format, args)

#define NN_DETAIL_TCAP_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Fatal, 0, format, args)
#define NN_DETAIL_TCAP_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Fatal, 1, format, args)
#define NN_DETAIL_TCAP_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Fatal, 2, format, args)
#define NN_DETAIL_TCAP_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tcap, Fatal, 3, format, args)

#define NN_DETAIL_TCAP_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Trace, 0, text, length)
#define NN_DETAIL_TCAP_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Trace, 1, text, length)
#define NN_DETAIL_TCAP_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Trace, 2, text, length)
#define NN_DETAIL_TCAP_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Trace, 3, text, length)

#define NN_DETAIL_TCAP_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Info, 0, text, length)
#define NN_DETAIL_TCAP_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Info, 1, text, length)
#define NN_DETAIL_TCAP_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Info, 2, text, length)
#define NN_DETAIL_TCAP_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Info, 3, text, length)

#define NN_DETAIL_TCAP_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Warn, 0, text, length)
#define NN_DETAIL_TCAP_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Warn, 1, text, length)
#define NN_DETAIL_TCAP_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Warn, 2, text, length)
#define NN_DETAIL_TCAP_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Warn, 3, text, length)

#define NN_DETAIL_TCAP_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Error, 0, text, length)
#define NN_DETAIL_TCAP_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Error, 1, text, length)
#define NN_DETAIL_TCAP_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Error, 2, text, length)
#define NN_DETAIL_TCAP_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Error, 3, text, length)

#define NN_DETAIL_TCAP_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Fatal, 0, text, length)
#define NN_DETAIL_TCAP_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Fatal, 1, text, length)
#define NN_DETAIL_TCAP_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Fatal, 2, text, length)
#define NN_DETAIL_TCAP_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tcap, Fatal, 3, text, length)
