﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace tc {

/**
 * @brief 動作モードを表す列挙型です。@ref nn::tc::SetOperatingMode で使用します。
 */
enum OperatingMode
{
    OperatingMode_Undefined = -1, //!< 無効なイベントです。
};

/**
 * @brief 温度確認が必要な操作を表す列挙型です。@ref nn::tc::IsActionAllowed で使用します。
 */
enum Action
{
    Action_Undefined = -1, //!< 無効なイベントです。
};

/**
 * @brief 温度センサーの位置を示す列挙型です。仮想温度を操作するときに使用します。
 */
enum Location
{
    Location_Undefined = -1, //!< 無効な温度センサーです
};

}} // namespace nn::tc
