﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 温度制御モジュールの API 宣言。
 */

#pragma once

#include <nn/nn_Result.h>
#include <nn/os.h>

#include "tc_Types.h"

namespace nn { namespace tc {

//! @name 本体の起床等の操作に関連する API
//! @{

/**
 * @brief       指定したイベントを @ref nn::os::SystemEventType 型のオブジェクトに関連付けて検知できるようにします。
 *
 * @param[out]  pOutEvent 指定したイベントに関連付けられる @ref nn::os::SystemEventType 型のオブジェクトです。
 * @param[in]   target 指定したイベントを表す @ref nn::tc::EventTarget 型のイベント識別子です。
 * @param[in]   mode イベントのクリア方法を指定する @ref nn::os::EventClearMode 型の値です。
 *
 * @return      処理の結果を返します。
 *
 * @details     指定したイベントを @ref nn::os::SystemEventType 型のオブジェクトに関連付けて検知できるようにします。@n
 *              pOutEvent は mode で指定したクリア方法で初期化されます。
 *              複数のクライアントから呼び出しには対応していません。
 */
nn::Result GetThermalEvent(nn::os::SystemEventType* pOutEvent, EventTarget target, nn::os::EventClearMode mode) NN_NOEXCEPT;

/**
 * @brief       指定した操作が温度の観点から許容できるかを真偽値で返します。
 *
 * @param[out]  pPossible 操作の可否を表す bool 型へのポインタです。
 * @param[in]   action 操作を表す @ref nn::tc::Action 型の列挙値です。
 *
 * @return      処理の結果を返します。
 *
 * @details     指定した操作が温度の観点から許容できるかを真偽値で返します。
 */
nn::Result IsActionAllowed(bool* pOutPossible, Action action) NN_NOEXCEPT;

//! @}

}} // namepsace nn::tc
