﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 温度制御モジュールの API 宣言。
 */

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace tc {

//! @name ファン制御操作 API
//! @{

/**
 * @brief       温度制御モジュールによるファンの制御を有効にします。
 *
 * @return      処理の結果を返します。
 *
 * @details     温度制御モジュールによる全てのファンの制御を有効にします。@n
 *              温度制御モジュール以外からファン制御モジュールを操作する場合に使用します。@n
 */
nn::Result EnableFanControl() NN_NOEXCEPT;

/**
 * @brief       温度制御モジュールによるファンの制御を無効にします。
 *
 * @return      処理の結果を返します。
 *
 * @details     温度制御モジュールによる全てのファンの制御を無効にします。@n
 *              温度制御モジュール以外からファン制御モジュールを操作する場合に使用します。
 */
nn::Result DisableFanControl() NN_NOEXCEPT;

/**
 * @brief       温度制御モジュールによるファンの制御の有効・無効を返します。
 *
 * @param[out]  現在のファンの制御の有効・無効を格納する bool 型へのポインタです。
 *
 * @return      処理の結果を返します。
 *
 * @details     温度制御モジュールによるファンの制御の有効・無効を返します。@n
 *              温度制御モジュール以外からファン制御モジュールを操作する場合に使用します。
 */
nn::Result IsFanControlEnabled(bool* pOutEnabled) NN_NOEXCEPT;

//! @}

}} // namepsace nn::tc
