﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      tc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_TC_TRACE(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_TC_TRACE_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_TC_TRACE_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_TC_TRACE_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_TC_INFO(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(tc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_TC_INFO_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_TC_INFO_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_TC_INFO_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_TC_WARN(...)                      NN_DETAIL_STRUCTURED_SDK_LOG(tc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_TC_WARN_V1(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_TC_WARN_V2(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_TC_WARN_V3(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(tc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_TC_ERROR(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_TC_ERROR_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_TC_ERROR_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_TC_ERROR_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_TC_FATAL(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_TC_FATAL_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_TC_FATAL_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_TC_FATAL_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_TC_VTRACE(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Trace, 0, format, args)
#define NN_DETAIL_TC_VTRACE_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Trace, 1, format, args)
#define NN_DETAIL_TC_VTRACE_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Trace, 2, format, args)
#define NN_DETAIL_TC_VTRACE_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Trace, 3, format, args)

#define NN_DETAIL_TC_VINFO(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Info, 0, format, args)
#define NN_DETAIL_TC_VINFO_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Info, 1, format, args)
#define NN_DETAIL_TC_VINFO_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Info, 2, format, args)
#define NN_DETAIL_TC_VINFO_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Info, 3, format, args)

#define NN_DETAIL_TC_VWARN(format, args)            NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Warn, 0, format, args)
#define NN_DETAIL_TC_VWARN_V1(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Warn, 1, format, args)
#define NN_DETAIL_TC_VWARN_V2(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Warn, 2, format, args)
#define NN_DETAIL_TC_VWARN_V3(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Warn, 3, format, args)

#define NN_DETAIL_TC_VERROR(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Error, 0, format, args)
#define NN_DETAIL_TC_VERROR_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Error, 1, format, args)
#define NN_DETAIL_TC_VERROR_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Error, 2, format, args)
#define NN_DETAIL_TC_VERROR_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Error, 3, format, args)

#define NN_DETAIL_TC_VFATAL(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Fatal, 0, format, args)
#define NN_DETAIL_TC_VFATAL_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Fatal, 1, format, args)
#define NN_DETAIL_TC_VFATAL_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Fatal, 2, format, args)
#define NN_DETAIL_TC_VFATAL_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tc, Fatal, 3, format, args)

#define NN_DETAIL_TC_PUT_TRACE(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tc, Trace, 0, text, length)
#define NN_DETAIL_TC_PUT_TRACE_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Trace, 1, text, length)
#define NN_DETAIL_TC_PUT_TRACE_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Trace, 2, text, length)
#define NN_DETAIL_TC_PUT_TRACE_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Trace, 3, text, length)

#define NN_DETAIL_TC_PUT_INFO(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(tc, Info, 0, text, length)
#define NN_DETAIL_TC_PUT_INFO_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tc, Info, 1, text, length)
#define NN_DETAIL_TC_PUT_INFO_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tc, Info, 2, text, length)
#define NN_DETAIL_TC_PUT_INFO_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tc, Info, 3, text, length)

#define NN_DETAIL_TC_PUT_WARN(text, length)         NN_DETAIL_STRUCTURED_SDK_PUT(tc, Warn, 0, text, length)
#define NN_DETAIL_TC_PUT_WARN_V1(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tc, Warn, 1, text, length)
#define NN_DETAIL_TC_PUT_WARN_V2(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tc, Warn, 2, text, length)
#define NN_DETAIL_TC_PUT_WARN_V3(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(tc, Warn, 3, text, length)

#define NN_DETAIL_TC_PUT_ERROR(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tc, Error, 0, text, length)
#define NN_DETAIL_TC_PUT_ERROR_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Error, 1, text, length)
#define NN_DETAIL_TC_PUT_ERROR_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Error, 2, text, length)
#define NN_DETAIL_TC_PUT_ERROR_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Error, 3, text, length)

#define NN_DETAIL_TC_PUT_FATAL(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tc, Fatal, 0, text, length)
#define NN_DETAIL_TC_PUT_FATAL_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Fatal, 1, text, length)
#define NN_DETAIL_TC_PUT_FATAL_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Fatal, 2, text, length)
#define NN_DETAIL_TC_PUT_FATAL_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tc, Fatal, 3, text, length)
