﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   ソフトウェアキーボードのインラインモードに関する API の宣言
 */

#pragma once

#include "swkbd_InlineKeyboardApi.h"

/**
 * @namespace nn::swkbd
 * @brief ソフトウェアキーボードアプレット呼び出しの名前空間です。
 */

namespace nn { namespace swkbd {

    // 当面は Cruiser 向け
    enum SeGroup : uint8_t
    {
        SeGroup_DeleteCharacter,   //!< 文字削除時SE
    };


    /**
     * @brief ソフトウェアキーボードをインラインモードで起動するためのクラスです。
     */
    class InlineKeyboardForLibraryApplet : public InlineKeyboard
    {

        NN_DISALLOW_COPY( InlineKeyboardForLibraryApplet );

    public:

        //! @name インラインモードの設定
        //! @{

        InlineKeyboardForLibraryApplet() NN_NOEXCEPT;
        ~InlineKeyboardForLibraryApplet() NN_NOEXCEPT;

        //------------------------------------------------------------------------
        /**
        * @brief ソフトウェアキーボードをインラインモードで起動します。
        *
        * @pre
        * - ソフトウェアキーボードが起動していない
        *
        * @param[in]  pWorkBuf   バッファの先頭ポインタです。@n
        *                        nn::swkbd::InlineKeyboard::GetRequiredWorkBufferSize() で取得できるバイトサイズを指定してください。
        * @param[in]  isOverlayLayer ソフトウェアキーボードが描画した結果を
        *                        アプレット側が表示するかどうかを設定するフラグです。@n
        *                        true を指定したときは直接画面に描画されるので nn::swkbd::InlineKeyboard::GetImage() を呼び出す必要はありません。
        * @param[in]  frameStep  フレームレートを指定します。1 を指定した場合 60fps、2 を指定した場合 30fps になります。@n
        *
        * @return
        *  ソフトウェアキーボード起動結果を返します。@n
        *  特に問題なければ true を返します。@n
        *  二重に起動しようとした場合は false を返します。
        *
        * @details
        *  ソフトウェアキーボードを起動します。@n
        *  内部で Launch 関数を実行しています。
        *
        * @deprecated 本 API は廃止予定です。バッファサイズ指定可能な Initialize 関数を使用してください。
        */
        bool Initialize( void* pWorkBuf, bool isOverlayLayer, int frameStep = 1 ) NN_NOEXCEPT;

        //------------------------------------------------------------------------
        /**
        * @brief ソフトウェアキーボードをインラインモードで起動します。
        *
        * @pre
        * - ソフトウェアキーボードが起動していない
        *
        * @param[in]  pWorkBuf   バッファの先頭ポインタです。@n
        *                        nn::swkbd::InlineKeyboard::GetRequiredWorkBufferSize() が返すサイズのバッファを指定してください。
        * @param[in]  bufferSize pWorkBuf に渡したバッファのサイズを指定ください。
        *
        * @param[in]  isOverlayLayer ソフトウェアキーボードが描画した結果を
        *                        アプレット側が表示するかどうかを設定するフラグです。@n
        *                        true を指定したときは直接画面に描画されるので nn::swkbd::InlineKeyboard::GetImage() を呼び出す必要はありません。
        * @param[in]  frameStep  フレームレートを指定します。1 を指定した場合 60fps、2 を指定した場合 30fps になります。@n
        *
        * @return
        *  ソフトウェアキーボード起動結果を返します。@n
        *  特に問題なければ true を返します。@n
        *  二重に起動しようとした場合は false を返します。
        *
        * @details
        *  ソフトウェアキーボードを起動します。@n
        *  内部で Launch 関数を実行しています。
        */
        bool Initialize(void* pWorkBuf, size_t bufferSize, bool isOverlayLayer, int frameStep) NN_NOEXCEPT;

        //------------------------------------------------------------------------
        /**
        * @brief 指定したSEを有効化/無効化します
        *
        * @param[in]    group   対象とするSEのグループIDを指定します。
        *
        * @param[in]    enable  true の場合はSEを有効化、false の場合は無効化します。@n
        *                       デフォルトは true です。
        *
        */
        void EnableSe( SeGroup group, bool enable ) NN_NOEXCEPT;

        //------------------------------------------------------------------------
        /**
        * @brief バックスペースボタンを有効化/無効化します
        *
        * @param[in]    enable  true の場合はバックスペースボタンを有効化、false の場合は無効化します。 @n
        *                       デフォルトは true です。
        *
        */
        void EnableBackspace( bool enable ) NN_NOEXCEPT;
    };

}} // namespace nn::swkbd

