﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_TimeSpan.h>
#include <nn/spsm/detail/spsm_TransitionInfo.h>

#include <nn/psc/util/psc_Util.h>

namespace nn { namespace spsm {

    // SF で受け渡す構造体であるので、os::Tick を使わず POD にする
    struct SleepWakeSequenceAnalyzedData {
        int64_t timeStampSleepTrigger;
        int64_t timeStampFullAwakeExit;
        int64_t timeStampMinimumAwakeDownwardDone;
        int64_t timeStampSleepReadyDone;
        int64_t timeStampEssentialServicesSleepReadyDone;
        int64_t timeStampSc7Entry;
        int64_t timeStampSc7Exit;
        int64_t timeStampEssentialServicesAwakeDone;
        int64_t timeStampMinimumAwakeUpwardDone;
        int64_t timeStampFullAwakeDone;
    };

    const int MaxPscTransitionCount = 6;

    struct SleepWakeSequencePerformanceData
    {
        detail::PscTransition data[MaxPscTransitionCount];
        int validDataCount;
    };

    // 解析用機能
    void AnalyzeLogForLastSleepWakeSequence(SleepWakeSequenceAnalyzedData* pOutData) NN_NOEXCEPT;
    void AnalyzePerformanceLogForLastSleepWakeSequence(SleepWakeSequencePerformanceData* pOutData) NN_NOEXCEPT;
    void ResetEventLog() NN_NOEXCEPT;
}}
