﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/spsm/spsm_PowerStateTypes.h>

namespace nn { namespace spsm { namespace server {

    // spsm サーバの初期化モード
    enum InitializeMode
    {
        InitializeMode_Normal,
        InitializeMode_Maintenance,
        InitializeMode_NoWait, // PSC のモジュール登録待ちを行わない
    };

    class StateChangeObserver : public nn::util::IntrusiveListBaseNode<StateChangeObserver>
    {
    public:
        explicit StateChangeObserver(std::function<void(PowerState)> onStateEntry, std::function<void(PowerState)> onStateExit) NN_NOEXCEPT
            : m_HandlerOnStateEntry(onStateEntry)
            , m_HandlerOnStateExit(onStateExit)
        {
            NN_SDK_ASSERT_NOT_NULL(m_HandlerOnStateEntry);
            NN_SDK_ASSERT_NOT_NULL(m_HandlerOnStateExit);
        }
        void OnStateEntry(PowerState enteredState) const NN_NOEXCEPT
        {
            if ( m_HandlerOnStateEntry )
            {
                m_HandlerOnStateEntry(enteredState);
            }
        }
        void OnStateExit(PowerState exitedState) const NN_NOEXCEPT
        {
            if ( m_HandlerOnStateExit )
            {
                m_HandlerOnStateExit(exitedState);
            }
        }

    private:
        std::function<void(PowerState)> m_HandlerOnStateEntry;
        std::function<void(PowerState)> m_HandlerOnStateExit;
    };
    typedef nn::util::IntrusiveList<StateChangeObserver, nn::util::IntrusiveListBaseNodeTraits<StateChangeObserver>> StateChangeObserverList;

}}}
