﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/spsm/spsm_Debug.h>
#include <nn/spsm/spsm_PowerStateTypes.h>
#include <nn/spsm/server/spsm_PowerStateMessageQueue.h>
#include <nn/spsm/server/spsm_ServerTypes.h>

namespace nn { namespace spsm { namespace server {

    class ServerInterfaceImpl
    {
        NN_DISALLOW_COPY(ServerInterfaceImpl);
        NN_DISALLOW_MOVE(ServerInterfaceImpl);

    public:
        ServerInterfaceImpl() NN_NOEXCEPT;

        // SF クライアント向けインタフェース
        Result GetCurrentState(nn::sf::Out<std::int32_t> outCurrentState) NN_NOEXCEPT;
        Result EnterSleep(nn::sf::Out<nn::sf::NativeHandle> outAwakeEventHandle) NN_NOEXCEPT;
        Result GetLastWakeReason(nn::sf::Out<nn::spsm::WakeReasonFlagSet> wakeReason) NN_NOEXCEPT;
        Result Shutdown(bool reboot) NN_NOEXCEPT;
        Result GetNotificationMessageEventHandle(nn::sf::Out<nn::sf::NativeHandle> outNotificationMessageEventHandle) NN_NOEXCEPT;
        Result ReceiveNotificationMessage(nn::sf::Out<std::int32_t> outMessage) NN_NOEXCEPT;
        Result AnalyzeLogForLastSleepWakeSequence(nn::sf::Out<SleepWakeSequenceAnalyzedData> outData) NN_NOEXCEPT;
        Result AnalyzePerformanceLogForLastSleepWakeSequence(const nn::sf::OutBuffer& outData) NN_NOEXCEPT;
        Result ResetEventLog() NN_NOEXCEPT;
        Result PutErrorState() NN_NOEXCEPT;
    };

    // サーバプロセス向けインタフェース
    void InitializePowerStateMachine(const InitializeMode mode) NN_NOEXCEPT;
    void LoopPowerStateMachine() NN_NOEXCEPT;

    // オブザーバ向けインタフェース
    PowerStateMessageQueue* GetPowerStateMessageQueue() NN_NOEXCEPT;
    void AddStateChangeObserver(StateChangeObserver* pObserver) NN_NOEXCEPT;
    void RemoveStateChangeObserver(StateChangeObserver* pObserver) NN_NOEXCEPT;

}}}
