﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       USB 設定に関するシステムアプリケーション向け設定 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

//! @name USB 設定関連 API
//! @{

/**
 * @brief       USB 3.0 が有効か否かを表す値を返します。
 *
 * @return      USB 3.0 が有効か否かを表す値です。
 */
bool IsUsb30Enabled() NN_NOEXCEPT;

/**
 * @brief       USB 3.0 が有効か否かを表す値を設定します。
 *
 * @param[in]   enable                      USB 3.0 が有効か否かを表す値
 */
void SetUsb30Enabled(bool enable) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
