﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       サービスディスカバリ設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/time/time_Types.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       サービスディスカバリの制御フラグ定義です。
 */
struct ServiceDiscoveryControlFlag
{
    typedef ::nn::util::BitFlagSet<32, ServiceDiscoveryControlFlag>::Flag<0>
            IsChangeEnvironmentIdentifierDisabled;  //!< 環境識別子を変更する設定インポートが無効化されているか否か
};

/**
 * @brief       サービスディスカバリの制御フラグ集合を扱う型です。
 */
typedef ::nn::util::BitFlagSet<32, ServiceDiscoveryControlFlag> ServiceDiscoveryControlFlagSet;

/**
 * @brief       サービスディスカバリの制御設定を表す構造体です。
 */
struct ServiceDiscoveryControlSettings
{
    ServiceDiscoveryControlFlagSet flag; //!< 制御フラグ
};

/**
 * @brief       サービスディスカバリの制御設定を取得します。
 *
 * @param[out]  pOutValue                   制御設定を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetServiceDiscoveryControlSettings(ServiceDiscoveryControlSettings* pOutValue) NN_NOEXCEPT;

/**
 * @brief       サービスディスカバリの制御設定を変更します。
 *
 * @param[in]   value                       制御設定
 */
void SetServiceDiscoveryControlSettings(const ServiceDiscoveryControlSettings& value) NN_NOEXCEPT;

}}} // namespace nn::settings::system
