﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   リージョンに関するシステムアプリケーション向け設定 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       リージョンコードを表す構造体です。
 */
enum RegionCode
{
    RegionCode_Japan = 0,       //!< 日本リージョン
    RegionCode_Usa = 1,         //!< 米国リージョン
    RegionCode_Europe = 2,      //!< 欧州リージョン
    RegionCode_Australia = 3,   //!< 豪州リージョン
    RegionCode_China = 4,       //!< 中国リージョン
    RegionCode_Korea = 5,       //!< 韓国リージョン
    RegionCode_Taiwan = 6,      //!< 台湾リージョン
};

/**
 * @brief       リージョンコードを取得します。
 *
 * @param[out]  pOutValue                   リージョンコードを読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetRegionCode(RegionCode* pOutValue) NN_NOEXCEPT;

/**
 * @brief       リージョンコードを取得します。
 *
 * @param[in]   value                       リージョンコード
 */
void SetRegionCode(RegionCode value) NN_NOEXCEPT;

}}} // nn::settings::system
