﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       プッシュ通知に関する設定 API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       プッシュ通知のスリープ状態における動作モードを返します。
 *
 * @return      プッシュ通知のスリープ状態における動作モードです。
 */
int32_t GetPushNotificationActivityModeOnSleep() NN_NOEXCEPT;

/**
 * @brief       プッシュ通知のスリープ状態における動作モードを設定します。
 *
 * @param[in]   value                           動作モード
 */
void SetPushNotificationActivityModeOnSleep(int32_t value) NN_NOEXCEPT;

}}} // nn::settings::system
