﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ローカル通信設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

//! @name ローカル通信設定関連 API
//! @{

/**
 * @brief       ローカル通信のチャンネルを返します。
 *
 * @return      ローカル通信のチャンネルです。
 */
int32_t GetLdnChannel() NN_NOEXCEPT;

/**
 * @brief       ローカル通信のチャンネルを設定します。
 *
 * @param[in]   value                       ローカル通信のチャンネル
 */
void SetLdnChannel(int32_t value) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
