﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       言語設定に関するシステムアプリケーション向け設定 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/settings_Language.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings {

//! @name 言語設定関連 API
//! @{

/**
 * @brief       言語設定を取得します。
 *
 * @details     言語設定として指定されている言語コードを取得します。
 *
 * @param[out]  outValue                    言語コードを読み出すバッファ
 *
 * @pre
 *              - outValue != nullptr
 * @post
 *              - *outValue は利用可能な言語コード
 */
void GetLanguageCode(LanguageCode* outValue) NN_NOEXCEPT;

//! @}

}} // nn::settings

namespace nn { namespace settings { namespace system {

//! @name 言語設定関連 API
//! @{

/**
 * @brief       言語設定を変更します。
 *
 * @details     指定された言語コードに言語設定を変更します。
 *
 * @param[in]   value                       言語コード
 *
 * @pre
 *              - value は利用可能な言語コード
 */
void SetLanguageCode(const LanguageCode& value) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
