﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   キーボード設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/settings_Keyboard.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

//! @name キーボード設定関連 API
//! @{

/**
 * @brief       キーボード配列の種別を取得します。
 *
 * @return      キーボード配列の種別を返します。
 */
KeyboardLayout GetKeyboardLayout() NN_NOEXCEPT;

/**
 * @brief       キーボード配列の種別を設定します。
 *
 * @param[in]   value                       キーボード配列の種別
 */
void SetKeyboardLayout(KeyboardLayout value) NN_NOEXCEPT;

/**
 * @brief       アプリケーション側で保持するキーボード配列の種別を取得します。
 *
 * @param[out]  pOutValue                   キーボード配列の種別を読み出すバッファ
 *
 * @return      キーボード配列の種別が設定されているか否かを表す値を返します。
 *
 * @pre
 *              - pOutValue != nullptr
 */
bool GetApplicationOwnKeyboardLayout(KeyboardLayout* pOutValue) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
