﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   電池 LOT に関するシステムアプリケーション向け設定 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       電池 LOT を表す構造体です。
 */
struct BatteryLot
{
    char string[24]; //!< 電池 LOT 情報を表す文字列（NULL 終端）
};

/**
 * @brief       電池 LOT を取得します。
 *
 * @details     生産時に設定された電池 LOT を取得します。
 *
 * @param[out]  pOutValue                       電池 LOT を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetBatteryLot(BatteryLot* pOutValue) NN_NOEXCEPT;

}}} // nn::settings::system
