﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/settings/settings_ServiceTypes.h>
#include <nn/settings/system/settings_Web.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace settings { // NOLINT(whitespace/braces)

class IFirmwareDebugSettingsServer;

class ISettingsItemKeyIterator;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFirmwareDebugSettingsServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFirmwareDebugSettingsServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetSettingsItemValue, (const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key, const ::nn::sf::InBuffer& value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetSettingsItemValue, (const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateSettingsItemKeyIterator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::settings::ISettingsItemKeyIterator>> outValue, const ::nn::settings::SettingsName& name))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ReadSettings, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutBuffer& buffer, ::std::int32_t target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResetSettings, (::std::int32_t target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetWebInspectorFlag, (bool value))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetAllowedSslHosts, (const ::nn::sf::InArray<::nn::settings::system::AllowedSslHost>& values))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetHostFsMountPoint, (const ::nn::settings::system::HostFsMountPoint& value))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFirmwareDebugSettingsServer)

        ::nn::Result SetSettingsItemValue(const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key, const ::nn::sf::InBuffer& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetSettingsItemValue, (name, key, value));
        }

        ::nn::Result ResetSettingsItemValue(const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetSettingsItemValue, (name, key));
        }

        ::nn::Result CreateSettingsItemKeyIterator(::nn::sf::Out<::nn::sf::SharedPointer<::nn::settings::ISettingsItemKeyIterator>> outValue, const ::nn::settings::SettingsName& name) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateSettingsItemKeyIterator, (outValue, name));
        }

        ::nn::Result ReadSettings(::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutBuffer& buffer, ::std::int32_t target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ReadSettings, (outCount, buffer, target));
        }

        ::nn::Result ResetSettings(::std::int32_t target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResetSettings, (target));
        }

        ::nn::Result SetWebInspectorFlag(bool value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetWebInspectorFlag, (value));
        }

        ::nn::Result SetAllowedSslHosts(const ::nn::sf::InArray<::nn::settings::system::AllowedSslHost>& values) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetAllowedSslHosts, (values));
        }

        ::nn::Result SetHostFsMountPoint(const ::nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetHostFsMountPoint, (value));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFirmwareDebugSettingsServer
    {
    public:
        nn::Result SetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key, const nn::sf::InBuffer& value) NN_NOEXCEPT;
        nn::Result ResetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key) NN_NOEXCEPT;
        nn::Result CreateSettingsItemKeyIterator(nn::sf::Out<nn::sf::SharedPointer<nn::settings::ISettingsItemKeyIterator>> outValue, const nn::settings::SettingsName& name) NN_NOEXCEPT;
        nn::Result ReadSettings(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutBuffer& buffer, std::int32_t target) NN_NOEXCEPT;
        nn::Result ResetSettings(std::int32_t target) NN_NOEXCEPT;
        nn::Result SetWebInspectorFlag(bool value) NN_NOEXCEPT;
        nn::Result SetAllowedSslHosts(const nn::sf::InArray<nn::settings::system::AllowedSslHost>& values) NN_NOEXCEPT;
        nn::Result SetHostFsMountPoint(const nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key, const nn::sf::InBuffer& value) NN_NOEXCEPT;
    nn::Result ResetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key) NN_NOEXCEPT;
    nn::Result CreateSettingsItemKeyIterator(nn::sf::Out<nn::sf::SharedPointer<nn::settings::ISettingsItemKeyIterator>> outValue, const nn::settings::SettingsName& name) NN_NOEXCEPT;
    nn::Result ReadSettings(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutBuffer& buffer, std::int32_t target) NN_NOEXCEPT;
    nn::Result ResetSettings(std::int32_t target) NN_NOEXCEPT;
    nn::Result SetWebInspectorFlag(bool value) NN_NOEXCEPT;
    nn::Result SetAllowedSslHosts(const nn::sf::InArray<nn::settings::system::AllowedSslHost>& values) NN_NOEXCEPT;
    nn::Result SetHostFsMountPoint(const nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::settings::IFirmwareDebugSettingsServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSettingsItemValue, (const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key, const ::nn::sf::InBuffer& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetSettingsItemValue, (name, key, value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetSettingsItemValue, (const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetSettingsItemValue, (name, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSettingsItemKeyIterator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::settings::ISettingsItemKeyIterator>> outValue, const ::nn::settings::SettingsName& name))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateSettingsItemKeyIterator, (outValue, name));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSettings, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutBuffer& buffer, ::std::int32_t target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ReadSettings, (outCount, buffer, target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetSettings, (::std::int32_t target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResetSettings, (target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWebInspectorFlag, (bool value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetWebInspectorFlag, (value));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAllowedSslHosts, (const ::nn::sf::InArray<::nn::settings::system::AllowedSslHost>& values))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetAllowedSslHosts, (values));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHostFsMountPoint, (const ::nn::settings::system::HostFsMountPoint& value))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetHostFsMountPoint, (value));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::settings::IFirmwareDebugSettingsServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::settings::IFirmwareDebugSettingsServer))

    // nn::Result SetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key, const nn::sf::InBuffer& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetSettingsItemValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(name, 0, (const ::nn::settings::SettingsName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(key, 1, (const ::nn::settings::SettingsItemKey&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(value, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (name, key, value))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetSettingsItemValue)

    // nn::Result ResetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetSettingsItemValue)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(name, 0, (const ::nn::settings::SettingsName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(key, 1, (const ::nn::settings::SettingsItemKey&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (name, key))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetSettingsItemValue)

    // nn::Result CreateSettingsItemKeyIterator(nn::sf::Out<nn::sf::SharedPointer<nn::settings::ISettingsItemKeyIterator>> outValue, const nn::settings::SettingsName& name) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateSettingsItemKeyIterator)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(name, 0, (const ::nn::settings::SettingsName&), 72, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (name))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateSettingsItemKeyIterator)

    // nn::Result ReadSettings(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutBuffer& buffer, std::int32_t target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReadSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReadSettings)

    // nn::Result ResetSettings(std::int32_t target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetSettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetSettings)

    // nn::Result SetWebInspectorFlag(bool value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetWebInspectorFlag)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(value, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (value))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetWebInspectorFlag)

    // nn::Result SetAllowedSslHosts(const nn::sf::InArray<nn::settings::system::AllowedSslHost>& values) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetAllowedSslHosts)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(values, 0, (const ::nn::sf::InArray<::nn::settings::system::AllowedSslHost>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (values))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(values)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetAllowedSslHosts)

    // nn::Result SetHostFsMountPoint(const nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetHostFsMountPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(value, 0, (const ::nn::settings::system::HostFsMountPoint&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (value))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(value)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetHostFsMountPoint)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::SettingsName), 72, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::SettingsItemKey), 72, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::system::AllowedSslHost), 256, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::system::HostFsMountPoint), 256, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::settings::IFirmwareDebugSettingsServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::settings::IFirmwareDebugSettingsServer))

    // nn::Result SetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key, const nn::sf::InBuffer& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetSettingsItemValue, (const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key, const ::nn::sf::InBuffer& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetSettingsItemValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetSettingsItemValue)
    }

    // nn::Result ResetSettingsItemValue(const nn::settings::SettingsName& name, const nn::settings::SettingsItemKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetSettingsItemValue, (const ::nn::settings::SettingsName& name, const ::nn::settings::SettingsItemKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetSettingsItemValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetSettingsItemValue)
    }

    // nn::Result CreateSettingsItemKeyIterator(nn::sf::Out<nn::sf::SharedPointer<nn::settings::ISettingsItemKeyIterator>> outValue, const nn::settings::SettingsName& name) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateSettingsItemKeyIterator, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::settings::ISettingsItemKeyIterator>> outValue, const ::nn::settings::SettingsName& name))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateSettingsItemKeyIterator)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateSettingsItemKeyIterator)
    }

    // nn::Result ReadSettings(nn::sf::Out<std::uint64_t> outCount, const nn::sf::OutBuffer& buffer, std::int32_t target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ReadSettings, (::nn::sf::Out<::std::uint64_t> outCount, const ::nn::sf::OutBuffer& buffer, ::std::int32_t target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReadSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReadSettings)
    }

    // nn::Result ResetSettings(std::int32_t target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResetSettings, (::std::int32_t target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetSettings)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetSettings)
    }

    // nn::Result SetWebInspectorFlag(bool value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWebInspectorFlag, (bool value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetWebInspectorFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetWebInspectorFlag)
    }

    // nn::Result SetAllowedSslHosts(const nn::sf::InArray<nn::settings::system::AllowedSslHost>& values) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetAllowedSslHosts, (const ::nn::sf::InArray<::nn::settings::system::AllowedSslHost>& values))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetAllowedSslHosts)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(values)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetAllowedSslHosts)
    }

    // nn::Result SetHostFsMountPoint(const nn::settings::system::HostFsMountPoint& value) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHostFsMountPoint, (const ::nn::settings::system::HostFsMountPoint& value))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetHostFsMountPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(value)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetHostFsMountPoint)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::settings::IFirmwareDebugSettingsServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::settings::IFirmwareDebugSettingsServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetSettingsItemValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(key)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(value)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetSettingsItemValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetSettingsItemValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(key)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetSettingsItemValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateSettingsItemKeyIterator)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::settings::ISettingsItemKeyIterator>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateSettingsItemKeyIterator)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReadSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReadSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetSettings)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetWebInspectorFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetWebInspectorFlag)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetAllowedSslHosts)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(values)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetAllowedSslHosts)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(values)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetHostFsMountPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(value)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetHostFsMountPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(value)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetSettingsItemValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetSettingsItemValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateSettingsItemKeyIterator)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReadSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetSettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetWebInspectorFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetAllowedSslHosts)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetHostFsMountPoint)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::settings::IFirmwareDebugSettingsServer))

namespace nn { namespace settings { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISettingsItemKeyIterator, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISettingsItemKeyIterator)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GoNext)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetKeySize, (::nn::sf::Out<::std::uint64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetKey, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISettingsItemKeyIterator)

        ::nn::Result GoNext() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GoNext);
        }

        ::nn::Result GetKeySize(::nn::sf::Out<::std::uint64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetKeySize, (outValue));
        }

        ::nn::Result GetKey(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetKey, (outValue, buffer));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISettingsItemKeyIterator
    {
    public:
        nn::Result GoNext() NN_NOEXCEPT;
        nn::Result GetKeySize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
        nn::Result GetKey(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
    };
#endif

}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GoNext() NN_NOEXCEPT;
    nn::Result GetKeySize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
    nn::Result GetKey(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::settings::ISettingsItemKeyIterator))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GoNext)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GoNext);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetKeySize, (::nn::sf::Out<::std::uint64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetKeySize, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetKey, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetKey, (outValue, buffer));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::settings::ISettingsItemKeyIterator>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::settings::ISettingsItemKeyIterator))

    // nn::Result GoNext() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GoNext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GoNext)

    // nn::Result GetKeySize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetKeySize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetKeySize)

    // nn::Result GetKey(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetKey)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::settings::ISettingsItemKeyIterator, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::settings::ISettingsItemKeyIterator))

    // nn::Result GoNext() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GoNext)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GoNext)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GoNext)
    }

    // nn::Result GetKeySize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetKeySize, (::nn::sf::Out<::std::uint64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetKeySize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetKeySize)
    }

    // nn::Result GetKey(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetKey, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetKey)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::settings::ISettingsItemKeyIterator>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::settings::ISettingsItemKeyIterator))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GoNext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GoNext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetKeySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetKeySize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GoNext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetKeySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetKey)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::settings::ISettingsItemKeyIterator))
