﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ファームウェアデバッグ設定に関する共通 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>

/**
 * @namespace   nn::settings::fwdbg
 * @brief       ファームウェアデバッグ設定の名前空間です。
 */

namespace nn { namespace settings { namespace fwdbg {

const int SettingsNameLengthMax = 64;       //!< 設定の名前の最大文字列長

const int SettingsItemKeyLengthMax = 64;    //!< 設定項目のキーの最大文字列長

/**
 * @brief       デバッグモードが有効か否かを表す値を返します。
 *
 * @details     実行環境が開発環境ならば true を、市場環境ならば false を
 *              返します。
 *              設定項目の値の変更が反映されるのはデバッグモード時のみで、
 *              デバッグモードが無効な場合、常に既定値が得られます。
 *
 * @return      デバッグモードが有効か否かを表す値です。
 */
bool IsDebugModeEnabled() NN_NOEXCEPT;

}}} // namespace nn::settings::fwdbg
