﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace settings { namespace factory {

/**
 * @brief       製品シリアル番号を表す構造体です。
 */
struct SerialNumber
{
    char string[24];    //!< 製品シリアル番号を表す文字列（NULL 終端）
};

/**
 * @brief       製品シリアル番号を取得します。
 *
 * @details     製造時に設定された製品シリアル番号の値を取得します。
 *
 * @param[out]  pOutValue                    製品シリアル番号を読みだすバッファ
 *
 * @retresult
 * @handleresult{nn::settings::factory::ResultCalibrationDataFileSystemCorrupted}
 * @handleresult{nn::settings::factory::ResultCalibrationDataCrcError}
 * @endretresult
 *
 * @pre
 *              - pOutValue != nullptr
 */
::nn::Result GetSerialNumber(SerialNumber* pOutValue) NN_NOEXCEPT;

}}}
