﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   ゲームカード相互認証に関する API の宣言
 */

#pragma once

#include <nn/nn_BitTypes.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/factory/settings_Result.h>

namespace nn { namespace settings { namespace factory {

/**
 * @brief       ゲームカード相互認証秘密鍵を表す構造体です。
 */
struct GameCardKey
{
    uint32_t size;          //!< ゲームカード相互認証秘密鍵のバイト数
    ::nn::Bit8 data[308];   //!< ゲームカード相互認証秘密鍵
};

/**
 * @brief       ゲームカード相互認証証明書を表す構造体です。
 */
struct GameCardCertificate
{
    ::nn::Bit8 data[1024];  //!< ゲームカード相互認証証明書
};

/**
 * @brief       ゲームカード相互認証秘密鍵を取得します。
 *
 * @param[out]  pOutValue                    ゲームカード相互認証秘密鍵を読みだすバッファ
 *
 * @retresult
 * @handleresult{nn::settings::factory::ResultCalibrationDataFileSystemCorrupted}
 * @handleresult{nn::settings::factory::ResultCalibrationDataCrcError}
 * @endretresult
 *
 * @pre
 *              - pOutValue != nullptr
 */
::nn::Result GetGameCardKey(GameCardKey* pOutValue) NN_NOEXCEPT;

/**
 * @brief       ゲームカード相互認証証明書を取得します。
 *
 * @param[out]  pOutValue                    ゲームカード相互認証証明書を読みだすバッファ
 *
 * @retresult
 * @handleresult{nn::settings::factory::ResultCalibrationDataFileSystemCorrupted}
 * @handleresult{nn::settings::factory::ResultCalibrationDataShaError}
 * @endretresult
 *
 * @pre
 *              - pOutValue != nullptr
 */
::nn::Result GetGameCardCertificate(GameCardCertificate* pOutValue) NN_NOEXCEPT;

}}} // nn::settings::factory
