﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>
#include <nn/os/os_Tick.h>

namespace nn {
namespace sasbus {

/**
* @brief PeriodicReceiveMode に使用する Dummy のデータサイズです。
*/
const int DummyPeriodicReceiveModeDataSize = 12;

/**
* @brief PeriodicReceiveMode で RingLifo にため込むデータ数です。
*/
const int DummyPeriodicReceiveModeDataCountMax = 80;

/**
* @brief PeriodicReceiveMode に使用する Dummy のデータ構造定義です。
*/
struct DummyPeriodicReceiveModeDataType
{
    int64_t      samplingNumber;
    nn::Result   result;
    nn::os::Tick tick;
    char         data[DummyPeriodicReceiveModeDataSize];
};

}
}
