﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   SASBUS ドライバライブラリの初期化・終了機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace sasbus {

//! @name ライブラリの初期化・終了
//! @{

/**
 * @brief   SASBUS ドライバライブラリを初期化します。
 *
 * @post
 *  ライブラリは初期化済の状態になります。
 *
 * @details
 *  SASBUS ドライバライブラリを初期化します。@n
 *  本関数は二度以上呼ぶことができます。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief SASBUS ドライバライブラリを終了します。
 *
 * @pre
 *  ライブラリは 1 度以上初期化された状態である必要があります。
 *
 * @details
 *  SASBUS ドライバライブラリを終了します。@n
 *  @ref nn::sasbus::Initialize() と同数だけ本関数が呼ばれたとき、本関数はライブラリの終了処理を実行します。@n
 *  終了処理において、すべてのセッションはクローズ状態になります。
 */
void Finalize() NN_NOEXCEPT;

//! @}

} // sasbus
} // nn


