﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ライブラリのシステムプロセス用の型の宣言。
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace psm {

class IPsmSession;

/**
 * @brief セッションです。
 */
struct Session
{
    IPsmSession* _pHandle;
    ::nn::os::SystemEventType* _pEvent;
};

/**
 * @brief 電池電圧の状態です。
 */
enum BatteryVoltageState
{
    BatteryVoltageState_ShutdownRequired,               //!< シャットダウンが必要な電圧です。
    BatteryVoltageState_SleepRequired,                  //!< スリープが必要な電圧です。
    BatteryVoltageState_BoostPerformanceModeProhibited, //!< 起動は問題ないが @ref nn::oe::PerformanceMode_Boost への移行は認められない電圧です。
    BatteryVoltageState_Good,                           //!< 十分な電圧です。
};

}} // namespace nn::psm
