﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <type_traits>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/psm/psm_IPsmServer.sfdl.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace psm {

class PsmServer : public ::nn::sf::ISharedObject
{
    NN_DISALLOW_COPY(PsmServer);
    NN_DISALLOW_MOVE(PsmServer);

public:
    PsmServer() NN_NOEXCEPT;

    ~PsmServer() NN_NOEXCEPT;

    ::nn::Result GetBatteryChargePercentage(
        ::nn::sf::Out<int> outBatteryCharge) NN_NOEXCEPT;

    ::nn::Result GetRawBatteryChargePercentage(
        ::nn::sf::Out<double> outRawBatteryCharge) NN_NOEXCEPT;

    ::nn::Result GetChargerType(
        ::nn::sf::Out<int> outChargerType) NN_NOEXCEPT;

    ::nn::Result GetBatteryVoltageState(
        ::nn::sf::Out<int> outBatteryVoltageState) NN_NOEXCEPT;

    ::nn::Result GetBatteryAgePercentage(
        ::nn::sf::Out<double> outAge) NN_NOEXCEPT;

    ::nn::Result EnableBatteryCharging() NN_NOEXCEPT;

    ::nn::Result DisableBatteryCharging() NN_NOEXCEPT;

    ::nn::Result IsBatteryChargingEnabled(
        ::nn::sf::Out<bool> outIsEnabled) NN_NOEXCEPT;

    ::nn::Result AcquireControllerPowerSupply() NN_NOEXCEPT;

    ::nn::Result ReleaseControllerPowerSupply() NN_NOEXCEPT;

    ::nn::Result BindChargerTypeChangeEvent(
        ::nn::sf::Out<nn::sf::NativeHandle> outHandle,
        int clientId) NN_NOEXCEPT;

    ::nn::Result UnbindChargerTypeChangeEvent(int clientId) NN_NOEXCEPT;

    ::nn::Result OpenSession(
        ::nn::sf::Out<nn::sf::SharedPointer<nn::psm::IPsmSession>> outSession) NN_NOEXCEPT;

    ::nn::Result EnableEnoughPowerChargeEmulation() NN_NOEXCEPT;

    ::nn::Result DisableEnoughPowerChargeEmulation() NN_NOEXCEPT;

    ::nn::Result EnableFastBatteryCharging() NN_NOEXCEPT;

    ::nn::Result DisableFastBatteryCharging() NN_NOEXCEPT;

    ::nn::Result IsEnoughPowerSupplied(
        ::nn::sf::Out<bool> outIsEnoughPowerSupplied) NN_NOEXCEPT;

    ::nn::Result GetBatteryChargeInfoEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;

    ::nn::Result GetBatteryChargeInfoFields(nn::sf::Out<nn::psm::BatteryChargeInfoFields> outBatteryChargeInfoFields) NN_NOEXCEPT;

    ::nn::Result GetBatteryChargeCalibratedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;

private:
    typedef ::nn::sf::ExpHeapAllocator Allocator;
    Allocator m_Allocator;
    ::std::aligned_storage<4 * 1024>::type m_HeapBuffer;

    ::nn::lmem::HeapHandle m_HeapHandle;

    class PsmSession;
};

}} // namespace nn::psm
