﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>

#include <nn/psm/psm_IPsmManufactureServer.sfdl.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace psm {

class PsmManufactureServer : public ::nn::sf::ISharedObject
{
    NN_DISALLOW_COPY(PsmManufactureServer);
    NN_DISALLOW_MOVE(PsmManufactureServer);

public:
    PsmManufactureServer() NN_NOEXCEPT;

    ~PsmManufactureServer() NN_NOEXCEPT;

    ::nn::Result EnableSupplyRouteControl() NN_NOEXCEPT;

    ::nn::Result DisableSupplyRouteControl() NN_NOEXCEPT;

    ::nn::Result SetSupplyRoute(nn::psm::SupplyRoute powerSupplyRoute) NN_NOEXCEPT;
};

}} // namespace nn::psm
